unit MainForm;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Dialogs, FMXTee.Engine, FMXTee.Series,
  FMXTee.Procs, FMXTee.Chart, Data.Bind.EngExt, Fmx.Bind.DBEngExt, System.Rtti,
  System.Bindings.Outputs, Data.Bind.Components, Data.Bind.DBScope, Data.DB,
  Datasnap.DBClient, FMX.TabControl, FMX.Objects, FMX.Ani, FMX.Types3D,
  FMXTee.Chart3D;

type
  TTeeChartDBLinkDemo = class(TForm)
    BindScopeDB1: TBindScopeDB;
    ClientDataSet1: TClientDataSet;
    DataSource1: TDataSource;
    TabControl1: TTabControl;
    TabItem1: TTabItem;
    TabItem2: TTabItem;
    Chart1: TChart;
    Panel1: TPanel;
    Chart2: TChart;
    Series1: TAreaSeries;
    Image1: TImage;
    Image2: TImage;
    TabItem3: TTabItem;
    Viewport3D1: TViewport3D;
    Chart3DChart1: TChart;
    Chart3D1: TChart3D;
    Light1: TLight;
    Series2: TBarSeries;
    ColorAnimation1: TColorAnimation;
    Light3: TLight;
    procedure FormCreate(Sender: TObject);
    procedure Image1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TeeChartDBLinkDemo: TTeeChartDBLinkDemo;

implementation

{$R *.fmx}

uses
  FMXTee.Bind.DBLinks;

procedure TTeeChartDBLinkDemo.FormCreate(Sender: TObject);
var b : TBindDBChartLink;
begin
  TabControl1.ActiveTab:=TabItem1;

  // Chart1
  b:=TBindDBChartLink.Create(Self);
  b.DataSource:=BindScopeDB1;
  b.Chart:=Chart1;
  b.Active:=True;

  // Series1
  b:=TBindDBChartLink.Create(Self);
  b.DataSource:=BindScopeDB1;
  b.AddSeries(Series1, 'Size');
  b.Active:=True;

  // Chart3D1
  b:=TBindDBChartLink.Create(Self);
  b.DataSource:=BindScopeDB1;
  b.Chart:=Chart3D1.Chart;
  b.Active:=True;

  // Cosmetics
  (Chart3DChart1[0] as TBarSeries).BarStyle:=bsRoundRectangle;
  (Chart3DChart1[1] as TBarSeries).BarStyle:=bsRoundRectangle;
end;

procedure TTeeChartDBLinkDemo.Image1Click(Sender: TObject);
begin
  TeeGotoURL(Handle, 'http://www.steema.com');
end;

end.
